/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ConnectionAlias;
import software.amazon.awssdk.services.workspaces.model.ConnectionAliasListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionAliasesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeConnectionAliasesResponse> {
    private static final SdkField<List<ConnectionAlias>> CONNECTION_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionAliases").getter(DescribeConnectionAliasesResponse.getter(DescribeConnectionAliasesResponse::connectionAliases)).setter(DescribeConnectionAliasesResponse.setter(Builder::connectionAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConnectionAliasesResponse.getter(DescribeConnectionAliasesResponse::nextToken)).setter(DescribeConnectionAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ALIASES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConnectionAlias> connectionAliases;
    private final String nextToken;

    private DescribeConnectionAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.connectionAliases = builder.connectionAliases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectionAliases() {
        return this.connectionAliases != null && !(this.connectionAliases instanceof SdkAutoConstructList);
    }

    public final List<ConnectionAlias> connectionAliases() {
        return this.connectionAliases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionAliases() ? this.connectionAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionAliasesResponse)) {
            return false;
        }
        DescribeConnectionAliasesResponse other = (DescribeConnectionAliasesResponse)((Object)obj);
        return this.hasConnectionAliases() == other.hasConnectionAliases() && Objects.equals(this.connectionAliases(), other.connectionAliases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectionAliasesResponse").add("ConnectionAliases", this.hasConnectionAliases() ? this.connectionAliases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionAliases": {
                return Optional.ofNullable(clazz.cast(this.connectionAliases()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionAliasesResponse, T> g) {
        return obj -> g.apply((DescribeConnectionAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<ConnectionAlias> connectionAliases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionAliasesResponse model) {
            super(model);
            this.connectionAliases(model.connectionAliases);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectionAlias.Builder> getConnectionAliases() {
            List<ConnectionAlias.Builder> result = ConnectionAliasListCopier.copyToBuilder(this.connectionAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionAliases(Collection<ConnectionAlias.BuilderImpl> connectionAliases) {
            this.connectionAliases = ConnectionAliasListCopier.copyFromBuilder(connectionAliases);
        }

        @Override
        public final Builder connectionAliases(Collection<ConnectionAlias> connectionAliases) {
            this.connectionAliases = ConnectionAliasListCopier.copy(connectionAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAliases(ConnectionAlias ... connectionAliases) {
            this.connectionAliases(Arrays.asList(connectionAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionAliases(Consumer<ConnectionAlias.Builder> ... connectionAliases) {
            this.connectionAliases(Stream.of(connectionAliases).map(c -> (ConnectionAlias)((ConnectionAlias.Builder)ConnectionAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConnectionAliasesResponse build() {
            return new DescribeConnectionAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionAliasesResponse> {
        public Builder connectionAliases(Collection<ConnectionAlias> var1);

        public Builder connectionAliases(ConnectionAlias ... var1);

        public Builder connectionAliases(Consumer<ConnectionAlias.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

