/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequestListCopier;
import software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequestListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStandbyWorkspacesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, CreateStandbyWorkspacesResponse> {
    private static final SdkField<List<FailedCreateStandbyWorkspacesRequest>> FAILED_STANDBY_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedStandbyRequests").getter(CreateStandbyWorkspacesResponse.getter(CreateStandbyWorkspacesResponse::failedStandbyRequests)).setter(CreateStandbyWorkspacesResponse.setter(Builder::failedStandbyRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedStandbyRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedCreateStandbyWorkspacesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PendingCreateStandbyWorkspacesRequest>> PENDING_STANDBY_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingStandbyRequests").getter(CreateStandbyWorkspacesResponse.getter(CreateStandbyWorkspacesResponse::pendingStandbyRequests)).setter(CreateStandbyWorkspacesResponse.setter(Builder::pendingStandbyRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingStandbyRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingCreateStandbyWorkspacesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_STANDBY_REQUESTS_FIELD, PENDING_STANDBY_REQUESTS_FIELD));
    private final List<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests;
    private final List<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests;

    private CreateStandbyWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.failedStandbyRequests = builder.failedStandbyRequests;
        this.pendingStandbyRequests = builder.pendingStandbyRequests;
    }

    public final boolean hasFailedStandbyRequests() {
        return this.failedStandbyRequests != null && !(this.failedStandbyRequests instanceof SdkAutoConstructList);
    }

    public final List<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests() {
        return this.failedStandbyRequests;
    }

    public final boolean hasPendingStandbyRequests() {
        return this.pendingStandbyRequests != null && !(this.pendingStandbyRequests instanceof SdkAutoConstructList);
    }

    public final List<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests() {
        return this.pendingStandbyRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedStandbyRequests() ? this.failedStandbyRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingStandbyRequests() ? this.pendingStandbyRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStandbyWorkspacesResponse)) {
            return false;
        }
        CreateStandbyWorkspacesResponse other = (CreateStandbyWorkspacesResponse)((Object)obj);
        return this.hasFailedStandbyRequests() == other.hasFailedStandbyRequests() && Objects.equals(this.failedStandbyRequests(), other.failedStandbyRequests()) && this.hasPendingStandbyRequests() == other.hasPendingStandbyRequests() && Objects.equals(this.pendingStandbyRequests(), other.pendingStandbyRequests());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStandbyWorkspacesResponse").add("FailedStandbyRequests", this.hasFailedStandbyRequests() ? this.failedStandbyRequests() : null).add("PendingStandbyRequests", this.hasPendingStandbyRequests() ? this.pendingStandbyRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedStandbyRequests": {
                return Optional.ofNullable(clazz.cast(this.failedStandbyRequests()));
            }
            case "PendingStandbyRequests": {
                return Optional.ofNullable(clazz.cast(this.pendingStandbyRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStandbyWorkspacesResponse, T> g) {
        return obj -> g.apply((CreateStandbyWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests = DefaultSdkAutoConstructList.getInstance();
        private List<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStandbyWorkspacesResponse model) {
            super(model);
            this.failedStandbyRequests(model.failedStandbyRequests);
            this.pendingStandbyRequests(model.pendingStandbyRequests);
        }

        public final List<FailedCreateStandbyWorkspacesRequest.Builder> getFailedStandbyRequests() {
            List<FailedCreateStandbyWorkspacesRequest.Builder> result = FailedCreateStandbyWorkspacesRequestListCopier.copyToBuilder(this.failedStandbyRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedStandbyRequests(Collection<FailedCreateStandbyWorkspacesRequest.BuilderImpl> failedStandbyRequests) {
            this.failedStandbyRequests = FailedCreateStandbyWorkspacesRequestListCopier.copyFromBuilder(failedStandbyRequests);
        }

        @Override
        public final Builder failedStandbyRequests(Collection<FailedCreateStandbyWorkspacesRequest> failedStandbyRequests) {
            this.failedStandbyRequests = FailedCreateStandbyWorkspacesRequestListCopier.copy(failedStandbyRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedStandbyRequests(FailedCreateStandbyWorkspacesRequest ... failedStandbyRequests) {
            this.failedStandbyRequests(Arrays.asList(failedStandbyRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedStandbyRequests(Consumer<FailedCreateStandbyWorkspacesRequest.Builder> ... failedStandbyRequests) {
            this.failedStandbyRequests(Stream.of(failedStandbyRequests).map(c -> (FailedCreateStandbyWorkspacesRequest)((FailedCreateStandbyWorkspacesRequest.Builder)FailedCreateStandbyWorkspacesRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PendingCreateStandbyWorkspacesRequest.Builder> getPendingStandbyRequests() {
            List<PendingCreateStandbyWorkspacesRequest.Builder> result = PendingCreateStandbyWorkspacesRequestListCopier.copyToBuilder(this.pendingStandbyRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingStandbyRequests(Collection<PendingCreateStandbyWorkspacesRequest.BuilderImpl> pendingStandbyRequests) {
            this.pendingStandbyRequests = PendingCreateStandbyWorkspacesRequestListCopier.copyFromBuilder(pendingStandbyRequests);
        }

        @Override
        public final Builder pendingStandbyRequests(Collection<PendingCreateStandbyWorkspacesRequest> pendingStandbyRequests) {
            this.pendingStandbyRequests = PendingCreateStandbyWorkspacesRequestListCopier.copy(pendingStandbyRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingStandbyRequests(PendingCreateStandbyWorkspacesRequest ... pendingStandbyRequests) {
            this.pendingStandbyRequests(Arrays.asList(pendingStandbyRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingStandbyRequests(Consumer<PendingCreateStandbyWorkspacesRequest.Builder> ... pendingStandbyRequests) {
            this.pendingStandbyRequests(Stream.of(pendingStandbyRequests).map(c -> (PendingCreateStandbyWorkspacesRequest)((PendingCreateStandbyWorkspacesRequest.Builder)PendingCreateStandbyWorkspacesRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateStandbyWorkspacesResponse build() {
            return new CreateStandbyWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStandbyWorkspacesResponse> {
        public Builder failedStandbyRequests(Collection<FailedCreateStandbyWorkspacesRequest> var1);

        public Builder failedStandbyRequests(FailedCreateStandbyWorkspacesRequest ... var1);

        public Builder failedStandbyRequests(Consumer<FailedCreateStandbyWorkspacesRequest.Builder> ... var1);

        public Builder pendingStandbyRequests(Collection<PendingCreateStandbyWorkspacesRequest> var1);

        public Builder pendingStandbyRequests(PendingCreateStandbyWorkspacesRequest ... var1);

        public Builder pendingStandbyRequests(Consumer<PendingCreateStandbyWorkspacesRequest.Builder> ... var1);
    }
}

