/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCertificateBasedAuthPropertiesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ModifyCertificateBasedAuthPropertiesRequest.Builder, ModifyCertificateBasedAuthPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ModifyCertificateBasedAuthPropertiesRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<CertificateBasedAuthProperties> CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD = SdkField
            .<CertificateBasedAuthProperties> builder(MarshallingType.SDK_POJO)
            .memberName("CertificateBasedAuthProperties")
            .getter(getter(ModifyCertificateBasedAuthPropertiesRequest::certificateBasedAuthProperties))
            .setter(setter(Builder::certificateBasedAuthProperties))
            .constructor(CertificateBasedAuthProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBasedAuthProperties")
                    .build()).build();

    private static final SdkField<List<String>> PROPERTIES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PropertiesToDelete")
            .getter(getter(ModifyCertificateBasedAuthPropertiesRequest::propertiesToDeleteAsStrings))
            .setter(setter(Builder::propertiesToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD, PROPERTIES_TO_DELETE_FIELD));

    private final String resourceId;

    private final CertificateBasedAuthProperties certificateBasedAuthProperties;

    private final List<String> propertiesToDelete;

    private ModifyCertificateBasedAuthPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.certificateBasedAuthProperties = builder.certificateBasedAuthProperties;
        this.propertiesToDelete = builder.propertiesToDelete;
    }

    /**
     * <p>
     * The resource identifiers, in the form of directory IDs.
     * </p>
     * 
     * @return The resource identifiers, in the form of directory IDs.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The properties of the certificate-based authentication.
     * </p>
     * 
     * @return The properties of the certificate-based authentication.
     */
    public final CertificateBasedAuthProperties certificateBasedAuthProperties() {
        return certificateBasedAuthProperties;
    }

    /**
     * <p>
     * The properties of the certificate-based authentication you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertiesToDelete} method.
     * </p>
     * 
     * @return The properties of the certificate-based authentication you want to delete.
     */
    public final List<DeletableCertificateBasedAuthProperty> propertiesToDelete() {
        return DeletableCertificateBasedAuthPropertiesListCopier.copyStringToEnum(propertiesToDelete);
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertiesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertiesToDelete() {
        return propertiesToDelete != null && !(propertiesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties of the certificate-based authentication you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertiesToDelete} method.
     * </p>
     * 
     * @return The properties of the certificate-based authentication you want to delete.
     */
    public final List<String> propertiesToDeleteAsStrings() {
        return propertiesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBasedAuthProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertiesToDelete() ? propertiesToDeleteAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCertificateBasedAuthPropertiesRequest)) {
            return false;
        }
        ModifyCertificateBasedAuthPropertiesRequest other = (ModifyCertificateBasedAuthPropertiesRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(certificateBasedAuthProperties(), other.certificateBasedAuthProperties())
                && hasPropertiesToDelete() == other.hasPropertiesToDelete()
                && Objects.equals(propertiesToDeleteAsStrings(), other.propertiesToDeleteAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCertificateBasedAuthPropertiesRequest").add("ResourceId", resourceId())
                .add("CertificateBasedAuthProperties", certificateBasedAuthProperties())
                .add("PropertiesToDelete", hasPropertiesToDelete() ? propertiesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "CertificateBasedAuthProperties":
            return Optional.ofNullable(clazz.cast(certificateBasedAuthProperties()));
        case "PropertiesToDelete":
            return Optional.ofNullable(clazz.cast(propertiesToDeleteAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCertificateBasedAuthPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyCertificateBasedAuthPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCertificateBasedAuthPropertiesRequest> {
        /**
         * <p>
         * The resource identifiers, in the form of directory IDs.
         * </p>
         * 
         * @param resourceId
         *        The resource identifiers, in the form of directory IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The properties of the certificate-based authentication.
         * </p>
         * 
         * @param certificateBasedAuthProperties
         *        The properties of the certificate-based authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties);

        /**
         * <p>
         * The properties of the certificate-based authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateBasedAuthProperties.Builder}
         * avoiding the need to create one manually via {@link CertificateBasedAuthProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateBasedAuthProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #certificateBasedAuthProperties(CertificateBasedAuthProperties)}.
         * 
         * @param certificateBasedAuthProperties
         *        a consumer that will call methods on {@link CertificateBasedAuthProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateBasedAuthProperties(CertificateBasedAuthProperties)
         */
        default Builder certificateBasedAuthProperties(
                Consumer<CertificateBasedAuthProperties.Builder> certificateBasedAuthProperties) {
            return certificateBasedAuthProperties(CertificateBasedAuthProperties.builder()
                    .applyMutation(certificateBasedAuthProperties).build());
        }

        /**
         * <p>
         * The properties of the certificate-based authentication you want to delete.
         * </p>
         * 
         * @param propertiesToDelete
         *        The properties of the certificate-based authentication you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDeleteWithStrings(Collection<String> propertiesToDelete);

        /**
         * <p>
         * The properties of the certificate-based authentication you want to delete.
         * </p>
         * 
         * @param propertiesToDelete
         *        The properties of the certificate-based authentication you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDeleteWithStrings(String... propertiesToDelete);

        /**
         * <p>
         * The properties of the certificate-based authentication you want to delete.
         * </p>
         * 
         * @param propertiesToDelete
         *        The properties of the certificate-based authentication you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDelete(Collection<DeletableCertificateBasedAuthProperty> propertiesToDelete);

        /**
         * <p>
         * The properties of the certificate-based authentication you want to delete.
         * </p>
         * 
         * @param propertiesToDelete
         *        The properties of the certificate-based authentication you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToDelete(DeletableCertificateBasedAuthProperty... propertiesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String resourceId;

        private CertificateBasedAuthProperties certificateBasedAuthProperties;

        private List<String> propertiesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCertificateBasedAuthPropertiesRequest model) {
            super(model);
            resourceId(model.resourceId);
            certificateBasedAuthProperties(model.certificateBasedAuthProperties);
            propertiesToDeleteWithStrings(model.propertiesToDelete);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final CertificateBasedAuthProperties.Builder getCertificateBasedAuthProperties() {
            return certificateBasedAuthProperties != null ? certificateBasedAuthProperties.toBuilder() : null;
        }

        public final void setCertificateBasedAuthProperties(
                CertificateBasedAuthProperties.BuilderImpl certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties != null ? certificateBasedAuthProperties.build()
                    : null;
        }

        @Override
        public final Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        public final Collection<String> getPropertiesToDelete() {
            if (propertiesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return propertiesToDelete;
        }

        public final void setPropertiesToDelete(Collection<String> propertiesToDelete) {
            this.propertiesToDelete = DeletableCertificateBasedAuthPropertiesListCopier.copy(propertiesToDelete);
        }

        @Override
        public final Builder propertiesToDeleteWithStrings(Collection<String> propertiesToDelete) {
            this.propertiesToDelete = DeletableCertificateBasedAuthPropertiesListCopier.copy(propertiesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToDeleteWithStrings(String... propertiesToDelete) {
            propertiesToDeleteWithStrings(Arrays.asList(propertiesToDelete));
            return this;
        }

        @Override
        public final Builder propertiesToDelete(Collection<DeletableCertificateBasedAuthProperty> propertiesToDelete) {
            this.propertiesToDelete = DeletableCertificateBasedAuthPropertiesListCopier.copyEnumToString(propertiesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToDelete(DeletableCertificateBasedAuthProperty... propertiesToDelete) {
            propertiesToDelete(Arrays.asList(propertiesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCertificateBasedAuthPropertiesRequest build() {
            return new ModifyCertificateBasedAuthPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
