/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the standby WorkSpace that could not be created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedCreateStandbyWorkspacesRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedCreateStandbyWorkspacesRequest.Builder, FailedCreateStandbyWorkspacesRequest> {
    private static final SdkField<StandbyWorkspace> STANDBY_WORKSPACE_REQUEST_FIELD = SdkField
            .<StandbyWorkspace> builder(MarshallingType.SDK_POJO).memberName("StandbyWorkspaceRequest")
            .getter(getter(FailedCreateStandbyWorkspacesRequest::standbyWorkspaceRequest))
            .setter(setter(Builder::standbyWorkspaceRequest)).constructor(StandbyWorkspace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyWorkspaceRequest").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(FailedCreateStandbyWorkspacesRequest::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(FailedCreateStandbyWorkspacesRequest::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STANDBY_WORKSPACE_REQUEST_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final StandbyWorkspace standbyWorkspaceRequest;

    private final String errorCode;

    private final String errorMessage;

    private FailedCreateStandbyWorkspacesRequest(BuilderImpl builder) {
        this.standbyWorkspaceRequest = builder.standbyWorkspaceRequest;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Information about the standby WorkSpace that could not be created.
     * </p>
     * 
     * @return Information about the standby WorkSpace that could not be created.
     */
    public final StandbyWorkspace standbyWorkspaceRequest() {
        return standbyWorkspaceRequest;
    }

    /**
     * <p>
     * The error code that is returned if the standby WorkSpace could not be created.
     * </p>
     * 
     * @return The error code that is returned if the standby WorkSpace could not be created.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The text of the error message that is returned if the standby WorkSpace could not be created.
     * </p>
     * 
     * @return The text of the error message that is returned if the standby WorkSpace could not be created.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standbyWorkspaceRequest());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateStandbyWorkspacesRequest)) {
            return false;
        }
        FailedCreateStandbyWorkspacesRequest other = (FailedCreateStandbyWorkspacesRequest) obj;
        return Objects.equals(standbyWorkspaceRequest(), other.standbyWorkspaceRequest())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedCreateStandbyWorkspacesRequest").add("StandbyWorkspaceRequest", standbyWorkspaceRequest())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandbyWorkspaceRequest":
            return Optional.ofNullable(clazz.cast(standbyWorkspaceRequest()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedCreateStandbyWorkspacesRequest, T> g) {
        return obj -> g.apply((FailedCreateStandbyWorkspacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedCreateStandbyWorkspacesRequest> {
        /**
         * <p>
         * Information about the standby WorkSpace that could not be created.
         * </p>
         * 
         * @param standbyWorkspaceRequest
         *        Information about the standby WorkSpace that could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standbyWorkspaceRequest(StandbyWorkspace standbyWorkspaceRequest);

        /**
         * <p>
         * Information about the standby WorkSpace that could not be created.
         * </p>
         * This is a convenience method that creates an instance of the {@link StandbyWorkspace.Builder} avoiding the
         * need to create one manually via {@link StandbyWorkspace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandbyWorkspace.Builder#build()} is called immediately and its
         * result is passed to {@link #standbyWorkspaceRequest(StandbyWorkspace)}.
         * 
         * @param standbyWorkspaceRequest
         *        a consumer that will call methods on {@link StandbyWorkspace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standbyWorkspaceRequest(StandbyWorkspace)
         */
        default Builder standbyWorkspaceRequest(Consumer<StandbyWorkspace.Builder> standbyWorkspaceRequest) {
            return standbyWorkspaceRequest(StandbyWorkspace.builder().applyMutation(standbyWorkspaceRequest).build());
        }

        /**
         * <p>
         * The error code that is returned if the standby WorkSpace could not be created.
         * </p>
         * 
         * @param errorCode
         *        The error code that is returned if the standby WorkSpace could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The text of the error message that is returned if the standby WorkSpace could not be created.
         * </p>
         * 
         * @param errorMessage
         *        The text of the error message that is returned if the standby WorkSpace could not be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private StandbyWorkspace standbyWorkspaceRequest;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateStandbyWorkspacesRequest model) {
            standbyWorkspaceRequest(model.standbyWorkspaceRequest);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final StandbyWorkspace.Builder getStandbyWorkspaceRequest() {
            return standbyWorkspaceRequest != null ? standbyWorkspaceRequest.toBuilder() : null;
        }

        public final void setStandbyWorkspaceRequest(StandbyWorkspace.BuilderImpl standbyWorkspaceRequest) {
            this.standbyWorkspaceRequest = standbyWorkspaceRequest != null ? standbyWorkspaceRequest.build() : null;
        }

        @Override
        public final Builder standbyWorkspaceRequest(StandbyWorkspace standbyWorkspaceRequest) {
            this.standbyWorkspaceRequest = standbyWorkspaceRequest;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public FailedCreateStandbyWorkspacesRequest build() {
            return new FailedCreateStandbyWorkspacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
