/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientDeviceType {
    DEVICE_TYPE_WINDOWS("DeviceTypeWindows"),
    DEVICE_TYPE_OSX("DeviceTypeOsx"),
    DEVICE_TYPE_ANDROID("DeviceTypeAndroid"),
    DEVICE_TYPE_IOS("DeviceTypeIos"),
    DEVICE_TYPE_LINUX("DeviceTypeLinux"),
    DEVICE_TYPE_WEB("DeviceTypeWeb"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientDeviceType> VALUE_MAP;
    private final String value;

    private ClientDeviceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientDeviceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientDeviceType> knownValues() {
        EnumSet<ClientDeviceType> knownValues = EnumSet.allOf(ClientDeviceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientDeviceType.class, ClientDeviceType::toString);
    }
}

