/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmailmessageflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Reference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Reference> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(S3Reference.getter(S3Reference::bucket)).setter(S3Reference.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(S3Reference.getter(S3Reference::key)).setter(S3Reference.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectVersion").getter(S3Reference.getter(S3Reference::objectVersion)).setter(S3Reference.setter(Builder::objectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD, OBJECT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Reference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String key;
    private final String objectVersion;

    private S3Reference(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.objectVersion = builder.objectVersion;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String key() {
        return this.key;
    }

    public final String objectVersion() {
        return this.objectVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Reference)) {
            return false;
        }
        S3Reference other = (S3Reference)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.objectVersion(), other.objectVersion());
    }

    public final String toString() {
        return ToString.builder((String)"S3Reference").add("Bucket", (Object)this.bucket()).add("Key", (Object)this.key()).add("ObjectVersion", (Object)this.objectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "objectVersion": {
                return Optional.ofNullable(clazz.cast(this.objectVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bucket", BUCKET_FIELD);
        map.put("key", KEY_FIELD);
        map.put("objectVersion", OBJECT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Reference, T> g) {
        return obj -> g.apply((S3Reference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private String objectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Reference model) {
            this.bucket(model.bucket);
            this.key(model.key);
            this.objectVersion(model.objectVersion);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getObjectVersion() {
            return this.objectVersion;
        }

        public final void setObjectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
        }

        @Override
        public final Builder objectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        public S3Reference build() {
            return new S3Reference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Reference> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder objectVersion(String var1);
    }
}

