/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmailmessageflow;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workmailmessageflow.DefaultWorkMailMessageFlowClientBuilder;
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowClientBuilder;
import software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest;
import software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentResponse;
import software.amazon.awssdk.services.workmailmessageflow.model.InvalidContentLocationException;
import software.amazon.awssdk.services.workmailmessageflow.model.MessageFrozenException;
import software.amazon.awssdk.services.workmailmessageflow.model.MessageRejectedException;
import software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest;
import software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentResponse;
import software.amazon.awssdk.services.workmailmessageflow.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmailmessageflow.model.WorkMailMessageFlowException;

public interface WorkMailMessageFlowClient
extends SdkClient {
    public static final String SERVICE_NAME = "workmailmessageflow";

    public static WorkMailMessageFlowClient create() {
        return (WorkMailMessageFlowClient)WorkMailMessageFlowClient.builder().build();
    }

    public static WorkMailMessageFlowClientBuilder builder() {
        return new DefaultWorkMailMessageFlowClientBuilder();
    }

    default public <ReturnT> ReturnT getRawMessageContent(GetRawMessageContentRequest getRawMessageContentRequest, ResponseTransformer<GetRawMessageContentResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getRawMessageContent(Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest, ResponseTransformer<GetRawMessageContentResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return this.getRawMessageContent((GetRawMessageContentRequest)((Object)((GetRawMessageContentRequest.Builder)GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest)).build()), responseTransformer);
    }

    default public GetRawMessageContentResponse getRawMessageContent(GetRawMessageContentRequest getRawMessageContentRequest, Path destinationPath) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return (GetRawMessageContentResponse)((Object)this.getRawMessageContent(getRawMessageContentRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetRawMessageContentResponse getRawMessageContent(Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest, Path destinationPath) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return this.getRawMessageContent((GetRawMessageContentRequest)((Object)((GetRawMessageContentRequest.Builder)GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetRawMessageContentResponse> getRawMessageContent(GetRawMessageContentRequest getRawMessageContentRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return (ResponseInputStream)this.getRawMessageContent(getRawMessageContentRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetRawMessageContentResponse> getRawMessageContent(Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return this.getRawMessageContent((GetRawMessageContentRequest)((Object)((GetRawMessageContentRequest.Builder)GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest)).build()));
    }

    default public ResponseBytes<GetRawMessageContentResponse> getRawMessageContentAsBytes(GetRawMessageContentRequest getRawMessageContentRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return (ResponseBytes)this.getRawMessageContent(getRawMessageContentRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetRawMessageContentResponse> getRawMessageContentAsBytes(Consumer<GetRawMessageContentRequest.Builder> getRawMessageContentRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return this.getRawMessageContentAsBytes((GetRawMessageContentRequest)((Object)((GetRawMessageContentRequest.Builder)GetRawMessageContentRequest.builder().applyMutation(getRawMessageContentRequest)).build()));
    }

    default public PutRawMessageContentResponse putRawMessageContent(PutRawMessageContentRequest putRawMessageContentRequest) throws ResourceNotFoundException, InvalidContentLocationException, MessageRejectedException, MessageFrozenException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        throw new UnsupportedOperationException();
    }

    default public PutRawMessageContentResponse putRawMessageContent(Consumer<PutRawMessageContentRequest.Builder> putRawMessageContentRequest) throws ResourceNotFoundException, InvalidContentLocationException, MessageRejectedException, MessageFrozenException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        return this.putRawMessageContent((PutRawMessageContentRequest)((Object)((PutRawMessageContentRequest.Builder)PutRawMessageContentRequest.builder().applyMutation(putRawMessageContentRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

