/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGroupRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, UpdateGroupRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(UpdateGroupRequest.getter(UpdateGroupRequest::organizationId)).setter(UpdateGroupRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(UpdateGroupRequest.getter(UpdateGroupRequest::groupId)).setter(UpdateGroupRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiddenFromGlobalAddressList").getter(UpdateGroupRequest.getter(UpdateGroupRequest::hiddenFromGlobalAddressList)).setter(UpdateGroupRequest.setter(Builder::hiddenFromGlobalAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, GROUP_ID_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGroupRequest.memberNameToFieldInitializer();
    private final String organizationId;
    private final String groupId;
    private final Boolean hiddenFromGlobalAddressList;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.groupId = builder.groupId;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final Boolean hiddenFromGlobalAddressList() {
        return this.hiddenFromGlobalAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiddenFromGlobalAddressList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGroupRequest").add("OrganizationId", (Object)this.organizationId()).add("GroupId", (Object)this.groupId()).add("HiddenFromGlobalAddressList", (Object)this.hiddenFromGlobalAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "HiddenFromGlobalAddressList": {
                return Optional.ofNullable(clazz.cast(this.hiddenFromGlobalAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupRequest, T> g) {
        return obj -> g.apply((UpdateGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String groupId;
        private Boolean hiddenFromGlobalAddressList;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.groupId(model.groupId);
            this.hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return this.hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGroupRequest> {
        public Builder organizationId(String var1);

        public Builder groupId(String var1);

        public Builder hiddenFromGlobalAddressList(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

