/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.EntityState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListUsersFilters> {
    private static final SdkField<String> USERNAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsernamePrefix").getter(ListUsersFilters.getter(ListUsersFilters::usernamePrefix)).setter(ListUsersFilters.setter(Builder::usernamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernamePrefix").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayNamePrefix").getter(ListUsersFilters.getter(ListUsersFilters::displayNamePrefix)).setter(ListUsersFilters.setter(Builder::displayNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayNamePrefix").build()}).build();
    private static final SdkField<String> PRIMARY_EMAIL_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryEmailPrefix").getter(ListUsersFilters.getter(ListUsersFilters::primaryEmailPrefix)).setter(ListUsersFilters.setter(Builder::primaryEmailPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmailPrefix").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListUsersFilters.getter(ListUsersFilters::stateAsString)).setter(ListUsersFilters.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_USER_ID_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderUserIdPrefix").getter(ListUsersFilters.getter(ListUsersFilters::identityProviderUserIdPrefix)).setter(ListUsersFilters.setter(Builder::identityProviderUserIdPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderUserIdPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_PREFIX_FIELD, DISPLAY_NAME_PREFIX_FIELD, PRIMARY_EMAIL_PREFIX_FIELD, STATE_FIELD, IDENTITY_PROVIDER_USER_ID_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsersFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String usernamePrefix;
    private final String displayNamePrefix;
    private final String primaryEmailPrefix;
    private final String state;
    private final String identityProviderUserIdPrefix;

    private ListUsersFilters(BuilderImpl builder) {
        this.usernamePrefix = builder.usernamePrefix;
        this.displayNamePrefix = builder.displayNamePrefix;
        this.primaryEmailPrefix = builder.primaryEmailPrefix;
        this.state = builder.state;
        this.identityProviderUserIdPrefix = builder.identityProviderUserIdPrefix;
    }

    public final String usernamePrefix() {
        return this.usernamePrefix;
    }

    public final String displayNamePrefix() {
        return this.displayNamePrefix;
    }

    public final String primaryEmailPrefix() {
        return this.primaryEmailPrefix;
    }

    public final EntityState state() {
        return EntityState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String identityProviderUserIdPrefix() {
        return this.identityProviderUserIdPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usernamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEmailPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderUserIdPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersFilters)) {
            return false;
        }
        ListUsersFilters other = (ListUsersFilters)obj;
        return Objects.equals(this.usernamePrefix(), other.usernamePrefix()) && Objects.equals(this.displayNamePrefix(), other.displayNamePrefix()) && Objects.equals(this.primaryEmailPrefix(), other.primaryEmailPrefix()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.identityProviderUserIdPrefix(), other.identityProviderUserIdPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersFilters").add("UsernamePrefix", (Object)this.usernamePrefix()).add("DisplayNamePrefix", (Object)(this.displayNamePrefix() == null ? null : "*** Sensitive Data Redacted ***")).add("PrimaryEmailPrefix", (Object)this.primaryEmailPrefix()).add("State", (Object)this.stateAsString()).add("IdentityProviderUserIdPrefix", (Object)this.identityProviderUserIdPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsernamePrefix": {
                return Optional.ofNullable(clazz.cast(this.usernamePrefix()));
            }
            case "DisplayNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.displayNamePrefix()));
            }
            case "PrimaryEmailPrefix": {
                return Optional.ofNullable(clazz.cast(this.primaryEmailPrefix()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "IdentityProviderUserIdPrefix": {
                return Optional.ofNullable(clazz.cast(this.identityProviderUserIdPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UsernamePrefix", USERNAME_PREFIX_FIELD);
        map.put("DisplayNamePrefix", DISPLAY_NAME_PREFIX_FIELD);
        map.put("PrimaryEmailPrefix", PRIMARY_EMAIL_PREFIX_FIELD);
        map.put("State", STATE_FIELD);
        map.put("IdentityProviderUserIdPrefix", IDENTITY_PROVIDER_USER_ID_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersFilters, T> g) {
        return obj -> g.apply((ListUsersFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usernamePrefix;
        private String displayNamePrefix;
        private String primaryEmailPrefix;
        private String state;
        private String identityProviderUserIdPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersFilters model) {
            this.usernamePrefix(model.usernamePrefix);
            this.displayNamePrefix(model.displayNamePrefix);
            this.primaryEmailPrefix(model.primaryEmailPrefix);
            this.state(model.state);
            this.identityProviderUserIdPrefix(model.identityProviderUserIdPrefix);
        }

        public final String getUsernamePrefix() {
            return this.usernamePrefix;
        }

        public final void setUsernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
        }

        @Override
        public final Builder usernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
            return this;
        }

        public final String getDisplayNamePrefix() {
            return this.displayNamePrefix;
        }

        public final void setDisplayNamePrefix(String displayNamePrefix) {
            this.displayNamePrefix = displayNamePrefix;
        }

        @Override
        public final Builder displayNamePrefix(String displayNamePrefix) {
            this.displayNamePrefix = displayNamePrefix;
            return this;
        }

        public final String getPrimaryEmailPrefix() {
            return this.primaryEmailPrefix;
        }

        public final void setPrimaryEmailPrefix(String primaryEmailPrefix) {
            this.primaryEmailPrefix = primaryEmailPrefix;
        }

        @Override
        public final Builder primaryEmailPrefix(String primaryEmailPrefix) {
            this.primaryEmailPrefix = primaryEmailPrefix;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getIdentityProviderUserIdPrefix() {
            return this.identityProviderUserIdPrefix;
        }

        public final void setIdentityProviderUserIdPrefix(String identityProviderUserIdPrefix) {
            this.identityProviderUserIdPrefix = identityProviderUserIdPrefix;
        }

        @Override
        public final Builder identityProviderUserIdPrefix(String identityProviderUserIdPrefix) {
            this.identityProviderUserIdPrefix = identityProviderUserIdPrefix;
            return this;
        }

        public ListUsersFilters build() {
            return new ListUsersFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListUsersFilters> {
        public Builder usernamePrefix(String var1);

        public Builder displayNamePrefix(String var1);

        public Builder primaryEmailPrefix(String var1);

        public Builder state(String var1);

        public Builder state(EntityState var1);

        public Builder identityProviderUserIdPrefix(String var1);
    }
}

