/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FolderName {
    INBOX("INBOX"),
    DELETED_ITEMS("DELETED_ITEMS"),
    SENT_ITEMS("SENT_ITEMS"),
    DRAFTS("DRAFTS"),
    JUNK_EMAIL("JUNK_EMAIL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FolderName> VALUE_MAP;
    private final String value;

    private FolderName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FolderName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FolderName> knownValues() {
        EnumSet<FolderName> knownValues = EnumSet.allOf(FolderName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FolderName.class, FolderName::toString);
    }
}

