/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListPersonalAccessTokensRequest;
import software.amazon.awssdk.services.workmail.model.ListPersonalAccessTokensResponse;
import software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary;

public class ListPersonalAccessTokensPublisher
implements SdkPublisher<ListPersonalAccessTokensResponse> {
    private final WorkMailAsyncClient client;
    private final ListPersonalAccessTokensRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPersonalAccessTokensPublisher(WorkMailAsyncClient client, ListPersonalAccessTokensRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPersonalAccessTokensPublisher(WorkMailAsyncClient client, ListPersonalAccessTokensRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPersonalAccessTokensResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPersonalAccessTokensResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PersonalAccessTokenSummary> personalAccessTokenSummaries() {
        Function<ListPersonalAccessTokensResponse, Iterator> getIterator = response -> {
            if (response != null && response.personalAccessTokenSummaries() != null) {
                return response.personalAccessTokenSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPersonalAccessTokensResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPersonalAccessTokensResponseFetcher
    implements AsyncPageFetcher<ListPersonalAccessTokensResponse> {
        private ListPersonalAccessTokensResponseFetcher() {
        }

        public boolean hasNextPage(ListPersonalAccessTokensResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPersonalAccessTokensResponse> nextPage(ListPersonalAccessTokensResponse previousPage) {
            if (previousPage == null) {
                return ListPersonalAccessTokensPublisher.this.client.listPersonalAccessTokens(ListPersonalAccessTokensPublisher.this.firstRequest);
            }
            return ListPersonalAccessTokensPublisher.this.client.listPersonalAccessTokens((ListPersonalAccessTokensRequest)((Object)ListPersonalAccessTokensPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

