/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse;

public class ListMailDomainsPublisher
implements SdkPublisher<ListMailDomainsResponse> {
    private final WorkMailAsyncClient client;
    private final ListMailDomainsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMailDomainsPublisher(WorkMailAsyncClient client, ListMailDomainsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMailDomainsPublisher(WorkMailAsyncClient client, ListMailDomainsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMailDomainsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMailDomainsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMailDomainsResponseFetcher
    implements AsyncPageFetcher<ListMailDomainsResponse> {
        private ListMailDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListMailDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMailDomainsResponse> nextPage(ListMailDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListMailDomainsPublisher.this.client.listMailDomains(ListMailDomainsPublisher.this.firstRequest);
            }
            return ListMailDomainsPublisher.this.client.listMailDomains((ListMailDomainsRequest)((Object)ListMailDomainsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

