/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.worklink.model.WebsiteCaSummary;
import software.amazon.awssdk.services.worklink.model.WebsiteCaSummaryListCopier;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebsiteCertificateAuthoritiesResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, ListWebsiteCertificateAuthoritiesResponse> {
    private static final SdkField<List<WebsiteCaSummary>> WEBSITE_CERTIFICATE_AUTHORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WebsiteCertificateAuthorities").getter(ListWebsiteCertificateAuthoritiesResponse.getter(ListWebsiteCertificateAuthoritiesResponse::websiteCertificateAuthorities)).setter(ListWebsiteCertificateAuthoritiesResponse.setter(Builder::websiteCertificateAuthorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCertificateAuthorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebsiteCaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWebsiteCertificateAuthoritiesResponse.getter(ListWebsiteCertificateAuthoritiesResponse::nextToken)).setter(ListWebsiteCertificateAuthoritiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSITE_CERTIFICATE_AUTHORITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<WebsiteCaSummary> websiteCertificateAuthorities;
    private final String nextToken;

    private ListWebsiteCertificateAuthoritiesResponse(BuilderImpl builder) {
        super(builder);
        this.websiteCertificateAuthorities = builder.websiteCertificateAuthorities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWebsiteCertificateAuthorities() {
        return this.websiteCertificateAuthorities != null && !(this.websiteCertificateAuthorities instanceof SdkAutoConstructList);
    }

    public final List<WebsiteCaSummary> websiteCertificateAuthorities() {
        return this.websiteCertificateAuthorities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebsiteCertificateAuthorities() ? this.websiteCertificateAuthorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebsiteCertificateAuthoritiesResponse)) {
            return false;
        }
        ListWebsiteCertificateAuthoritiesResponse other = (ListWebsiteCertificateAuthoritiesResponse)((Object)obj);
        return this.hasWebsiteCertificateAuthorities() == other.hasWebsiteCertificateAuthorities() && Objects.equals(this.websiteCertificateAuthorities(), other.websiteCertificateAuthorities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWebsiteCertificateAuthoritiesResponse").add("WebsiteCertificateAuthorities", this.hasWebsiteCertificateAuthorities() ? this.websiteCertificateAuthorities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebsiteCertificateAuthorities": {
                return Optional.ofNullable(clazz.cast(this.websiteCertificateAuthorities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebsiteCertificateAuthoritiesResponse, T> g) {
        return obj -> g.apply((ListWebsiteCertificateAuthoritiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private List<WebsiteCaSummary> websiteCertificateAuthorities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebsiteCertificateAuthoritiesResponse model) {
            super(model);
            this.websiteCertificateAuthorities(model.websiteCertificateAuthorities);
            this.nextToken(model.nextToken);
        }

        public final List<WebsiteCaSummary.Builder> getWebsiteCertificateAuthorities() {
            List<WebsiteCaSummary.Builder> result = WebsiteCaSummaryListCopier.copyToBuilder(this.websiteCertificateAuthorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebsiteCertificateAuthorities(Collection<WebsiteCaSummary.BuilderImpl> websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities = WebsiteCaSummaryListCopier.copyFromBuilder(websiteCertificateAuthorities);
        }

        @Override
        public final Builder websiteCertificateAuthorities(Collection<WebsiteCaSummary> websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities = WebsiteCaSummaryListCopier.copy(websiteCertificateAuthorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteCertificateAuthorities(WebsiteCaSummary ... websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities(Arrays.asList(websiteCertificateAuthorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteCertificateAuthorities(Consumer<WebsiteCaSummary.Builder> ... websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities(Stream.of(websiteCertificateAuthorities).map(c -> (WebsiteCaSummary)((WebsiteCaSummary.Builder)WebsiteCaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWebsiteCertificateAuthoritiesResponse build() {
            return new ListWebsiteCertificateAuthoritiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebsiteCertificateAuthoritiesResponse> {
        public Builder websiteCertificateAuthorities(Collection<WebsiteCaSummary> var1);

        public Builder websiteCertificateAuthorities(WebsiteCaSummary ... var1);

        public Builder websiteCertificateAuthorities(Consumer<WebsiteCaSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

