/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.ResourceCollectionType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, GetResourcesRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourcesRequest.getter(GetResourcesRequest::authenticationToken)).setter(GetResourcesRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourcesRequest.getter(GetResourcesRequest::userId)).setter(GetResourcesRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()}).build();
    private static final SdkField<String> COLLECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourcesRequest.getter(GetResourcesRequest::collectionTypeAsString)).setter(GetResourcesRequest.setter(Builder::collectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("collectionType").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetResourcesRequest.getter(GetResourcesRequest::limit)).setter(GetResourcesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourcesRequest.getter(GetResourcesRequest::marker)).setter(GetResourcesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, USER_ID_FIELD, COLLECTION_TYPE_FIELD, LIMIT_FIELD, MARKER_FIELD));
    private final String authenticationToken;
    private final String userId;
    private final String collectionType;
    private final Integer limit;
    private final String marker;

    private GetResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.userId = builder.userId;
        this.collectionType = builder.collectionType;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String userId() {
        return this.userId;
    }

    public ResourceCollectionType collectionType() {
        return ResourceCollectionType.fromValue(this.collectionType);
    }

    public String collectionTypeAsString() {
        return this.collectionType;
    }

    public Integer limit() {
        return this.limit;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.collectionTypeAsString(), other.collectionTypeAsString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"GetResourcesRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)this.userId()).add("CollectionType", (Object)this.collectionTypeAsString()).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "CollectionType": {
                return Optional.ofNullable(clazz.cast(this.collectionTypeAsString()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesRequest, T> g) {
        return obj -> g.apply((GetResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String userId;
        private String collectionType;
        private Integer limit;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.userId(model.userId);
            this.collectionType(model.collectionType);
            this.limit(model.limit);
            this.marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getCollectionTypeAsString() {
            return this.collectionType;
        }

        @Override
        public final Builder collectionType(String collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        @Override
        public final Builder collectionType(ResourceCollectionType collectionType) {
            this.collectionType(collectionType == null ? null : collectionType.toString());
            return this;
        }

        public final void setCollectionType(String collectionType) {
            this.collectionType = collectionType;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesRequest build() {
            return new GetResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesRequest> {
        public Builder authenticationToken(String var1);

        public Builder userId(String var1);

        public Builder collectionType(String var1);

        public Builder collectionType(ResourceCollectionType var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

