/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCommentRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DeleteCommentRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteCommentRequest.getter(DeleteCommentRequest::authenticationToken)).setter(DeleteCommentRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteCommentRequest.getter(DeleteCommentRequest::documentId)).setter(DeleteCommentRequest.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteCommentRequest.getter(DeleteCommentRequest::versionId)).setter(DeleteCommentRequest.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionId").build()}).build();
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteCommentRequest.getter(DeleteCommentRequest::commentId)).setter(DeleteCommentRequest.setter(Builder::commentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CommentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, DOCUMENT_ID_FIELD, VERSION_ID_FIELD, COMMENT_ID_FIELD));
    private final String authenticationToken;
    private final String documentId;
    private final String versionId;
    private final String commentId;

    private DeleteCommentRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.commentId = builder.commentId;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public String versionId() {
        return this.versionId;
    }

    public String commentId() {
        return this.commentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCommentRequest)) {
            return false;
        }
        DeleteCommentRequest other = (DeleteCommentRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.commentId(), other.commentId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCommentRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DocumentId", (Object)this.documentId()).add("VersionId", (Object)this.versionId()).add("CommentId", (Object)this.commentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "CommentId": {
                return Optional.ofNullable(clazz.cast(this.commentId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCommentRequest, T> g) {
        return obj -> g.apply((DeleteCommentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String versionId;
        private String commentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCommentRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.versionId(model.versionId);
            this.commentId(model.commentId);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCommentRequest build() {
            return new DeleteCommentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteCommentRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder versionId(String var1);

        public Builder commentId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

