/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PrincipalRoleType {
    VIEWER("VIEWER"),
    CONTRIBUTOR("CONTRIBUTOR"),
    OWNER("OWNER"),
    COOWNER("COOWNER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PrincipalRoleType> VALUE_MAP;
    private final String value;

    private PrincipalRoleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PrincipalRoleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PrincipalRoleType> knownValues() {
        EnumSet<PrincipalRoleType> knownValues = EnumSet.allOf(PrincipalRoleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PrincipalRoleType.class, PrincipalRoleType::toString);
    }
}

