/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;
import software.amazon.awssdk.services.workdocs.model.GroupMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.services.workdocs.model.UserMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Participants
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Participants> {
    private static final SdkField<List<UserMetadata>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(Participants.getter(Participants::users)).setter(Participants.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GroupMetadata>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(Participants.getter(Participants::groups)).setter(Participants.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD, GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Users", USERS_FIELD);
            this.put("Groups", GROUPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<UserMetadata> users;
    private final List<GroupMetadata> groups;

    private Participants(BuilderImpl builder) {
        this.users = builder.users;
        this.groups = builder.groups;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<UserMetadata> users() {
        return this.users;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<GroupMetadata> groups() {
        return this.groups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participants)) {
            return false;
        }
        Participants other = (Participants)obj;
        return this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups());
    }

    public final String toString() {
        return ToString.builder((String)"Participants").add("Users", this.hasUsers() ? this.users() : null).add("Groups", this.hasGroups() ? this.groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Participants, T> g) {
        return obj -> g.apply((Participants)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UserMetadata> users = DefaultSdkAutoConstructList.getInstance();
        private List<GroupMetadata> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Participants model) {
            this.users(model.users);
            this.groups(model.groups);
        }

        public final List<UserMetadata.Builder> getUsers() {
            List<UserMetadata.Builder> result = UserMetadataListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserMetadata.BuilderImpl> users) {
            this.users = UserMetadataListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<UserMetadata> users) {
            this.users = UserMetadataListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserMetadata ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserMetadata.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserMetadata)((UserMetadata.Builder)UserMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GroupMetadata.Builder> getGroups() {
            List<GroupMetadata.Builder> result = GroupMetadataListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupMetadata.BuilderImpl> groups) {
            this.groups = GroupMetadataListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupMetadata ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupMetadata.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupMetadata)((GroupMetadata.Builder)GroupMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Participants build() {
            return new Participants(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Participants> {
        public Builder users(Collection<UserMetadata> var1);

        public Builder users(UserMetadata ... var1);

        public Builder users(Consumer<UserMetadata.Builder> ... var1);

        public Builder groups(Collection<GroupMetadata> var1);

        public Builder groups(GroupMetadata ... var1);

        public Builder groups(Consumer<GroupMetadata.Builder> ... var1);
    }
}

