/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.ResourceType;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceMetadata> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ResourceMetadata.getter(ResourceMetadata::typeAsString)).setter(ResourceMetadata.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceMetadata.getter(ResourceMetadata::name)).setter(ResourceMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ORIGINAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalName").getter(ResourceMetadata.getter(ResourceMetadata::originalName)).setter(ResourceMetadata.setter(Builder::originalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResourceMetadata.getter(ResourceMetadata::id)).setter(ResourceMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(ResourceMetadata.getter(ResourceMetadata::versionId)).setter(ResourceMetadata.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<UserMetadata> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Owner").getter(ResourceMetadata.getter(ResourceMetadata::owner)).setter(ResourceMetadata.setter(Builder::owner)).constructor(UserMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentId").getter(ResourceMetadata.getter(ResourceMetadata::parentId)).setter(ResourceMetadata.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, ORIGINAL_NAME_FIELD, ID_FIELD, VERSION_ID_FIELD, OWNER_FIELD, PARENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("OriginalName", ORIGINAL_NAME_FIELD);
            this.put("Id", ID_FIELD);
            this.put("VersionId", VERSION_ID_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("ParentId", PARENT_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String originalName;
    private final String id;
    private final String versionId;
    private final UserMetadata owner;
    private final String parentId;

    private ResourceMetadata(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.originalName = builder.originalName;
        this.id = builder.id;
        this.versionId = builder.versionId;
        this.owner = builder.owner;
        this.parentId = builder.parentId;
    }

    public final ResourceType type() {
        return ResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String originalName() {
        return this.originalName;
    }

    public final String id() {
        return this.id;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final UserMetadata owner() {
        return this.owner;
    }

    public final String parentId() {
        return this.parentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMetadata)) {
            return false;
        }
        ResourceMetadata other = (ResourceMetadata)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originalName(), other.originalName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.parentId(), other.parentId());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceMetadata").add("Type", (Object)this.typeAsString()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OriginalName", (Object)(this.originalName() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("VersionId", (Object)this.versionId()).add("Owner", (Object)this.owner()).add("ParentId", (Object)this.parentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OriginalName": {
                return Optional.ofNullable(clazz.cast(this.originalName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceMetadata, T> g) {
        return obj -> g.apply((ResourceMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String originalName;
        private String id;
        private String versionId;
        private UserMetadata owner;
        private String parentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMetadata model) {
            this.type(model.type);
            this.name(model.name);
            this.originalName(model.originalName);
            this.id(model.id);
            this.versionId(model.versionId);
            this.owner(model.owner);
            this.parentId(model.parentId);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOriginalName() {
            return this.originalName;
        }

        public final void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        @Override
        public final Builder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final UserMetadata.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        public final void setOwner(UserMetadata.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(UserMetadata owner) {
            this.owner = owner;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public ResourceMetadata build() {
            return new ResourceMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceMetadata> {
        public Builder type(String var1);

        public Builder type(ResourceType var1);

        public Builder name(String var1);

        public Builder originalName(String var1);

        public Builder id(String var1);

        public Builder versionId(String var1);

        public Builder owner(UserMetadata var1);

        default public Builder owner(Consumer<UserMetadata.Builder> owner) {
            return this.owner((UserMetadata)((UserMetadata.Builder)UserMetadata.builder().applyMutation(owner)).build());
        }

        public Builder parentId(String var1);
    }
}

