/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserSortType {
    USER_NAME("USER_NAME"),
    FULL_NAME("FULL_NAME"),
    STORAGE_LIMIT("STORAGE_LIMIT"),
    USER_STATUS("USER_STATUS"),
    STORAGE_USED("STORAGE_USED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserSortType> VALUE_MAP;
    private final String value;

    private UserSortType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserSortType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserSortType> knownValues() {
        EnumSet<UserSortType> knownValues = EnumSet.allOf(UserSortType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserSortType.class, UserSortType::toString);
    }
}

