/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.Comment;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;

public class DescribeCommentsPublisher
implements SdkPublisher<DescribeCommentsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeCommentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCommentsPublisher(WorkDocsAsyncClient client, DescribeCommentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCommentsPublisher(WorkDocsAsyncClient client, DescribeCommentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCommentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCommentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Comment> comments() {
        Function<DescribeCommentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.comments() != null) {
                return response.comments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCommentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCommentsResponseFetcher
    implements AsyncPageFetcher<DescribeCommentsResponse> {
        private DescribeCommentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCommentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCommentsResponse> nextPage(DescribeCommentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCommentsPublisher.this.client.describeComments(DescribeCommentsPublisher.this.firstRequest);
            }
            return DescribeCommentsPublisher.this.client.describeComments((DescribeCommentsRequest)((Object)DescribeCommentsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

