/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.model.Comment;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;

public class DescribeCommentsIterable
implements SdkIterable<DescribeCommentsResponse> {
    private final WorkDocsClient client;
    private final DescribeCommentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCommentsIterable(WorkDocsClient client, DescribeCommentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCommentsResponseFetcher();
    }

    public Iterator<DescribeCommentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Comment> comments() {
        Function<DescribeCommentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.comments() != null) {
                return response.comments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCommentsResponseFetcher
    implements SyncPageFetcher<DescribeCommentsResponse> {
        private DescribeCommentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCommentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCommentsResponse nextPage(DescribeCommentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCommentsIterable.this.client.describeComments(DescribeCommentsIterable.this.firstRequest);
            }
            return DescribeCommentsIterable.this.client.describeComments((DescribeCommentsRequest)((Object)DescribeCommentsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

