/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.Principal;

public class DescribeResourcePermissionsPublisher
implements SdkPublisher<DescribeResourcePermissionsResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeResourcePermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeResourcePermissionsPublisher(WorkDocsAsyncClient client, DescribeResourcePermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeResourcePermissionsPublisher(WorkDocsAsyncClient client, DescribeResourcePermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeResourcePermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeResourcePermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Principal> principals() {
        Function<DescribeResourcePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeResourcePermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeResourcePermissionsResponseFetcher
    implements AsyncPageFetcher<DescribeResourcePermissionsResponse> {
        private DescribeResourcePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeResourcePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeResourcePermissionsResponse> nextPage(DescribeResourcePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeResourcePermissionsPublisher.this.client.describeResourcePermissions(DescribeResourcePermissionsPublisher.this.firstRequest);
            }
            return DescribeResourcePermissionsPublisher.this.client.describeResourcePermissions((DescribeResourcePermissionsRequest)((Object)DescribeResourcePermissionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

