/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workdocs.DefaultWorkDocsBaseClientBuilder;
import software.amazon.awssdk.services.workdocs.DefaultWorkDocsClient;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.WorkDocsClientBuilder;
import software.amazon.awssdk.services.workdocs.WorkDocsServiceClientConfiguration;
import software.amazon.awssdk.services.workdocs.endpoints.WorkDocsEndpointProvider;

@SdkInternalApi
final class DefaultWorkDocsClientBuilder
extends DefaultWorkDocsBaseClientBuilder<WorkDocsClientBuilder, WorkDocsClient>
implements WorkDocsClientBuilder {
    DefaultWorkDocsClientBuilder() {
    }

    @Override
    public DefaultWorkDocsClientBuilder endpointProvider(WorkDocsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkDocsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWorkDocsClientBuilder.validateClientOptions(clientConfiguration);
        WorkDocsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkDocsClient client = new DefaultWorkDocsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkDocsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkDocsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

