/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.User;

public class DescribeUsersPublisher
implements SdkPublisher<DescribeUsersResponse> {
    private final WorkDocsAsyncClient client;
    private final DescribeUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeUsersPublisher(WorkDocsAsyncClient client, DescribeUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeUsersPublisher(WorkDocsAsyncClient client, DescribeUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<User> users() {
        Function<DescribeUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeUsersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeUsersResponseFetcher
    implements AsyncPageFetcher<DescribeUsersResponse> {
        private DescribeUsersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeUsersResponse> nextPage(DescribeUsersResponse previousPage) {
            if (previousPage == null) {
                return DescribeUsersPublisher.this.client.describeUsers(DescribeUsersPublisher.this.firstRequest);
            }
            return DescribeUsersPublisher.this.client.describeUsers((DescribeUsersRequest)((Object)DescribeUsersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

