/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, GetResourcesResponse> {
    private static final SdkField<List<FolderMetadata>> FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Folders").getter(GetResourcesResponse.getter(GetResourcesResponse::folders)).setter(GetResourcesResponse.setter(Builder::folders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FolderMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentMetadata>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Documents").getter(GetResourcesResponse.getter(GetResourcesResponse::documents)).setter(GetResourcesResponse.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetResourcesResponse.getter(GetResourcesResponse::marker)).setter(GetResourcesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDERS_FIELD, DOCUMENTS_FIELD, MARKER_FIELD));
    private final List<FolderMetadata> folders;
    private final List<DocumentMetadata> documents;
    private final String marker;

    private GetResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.folders = builder.folders;
        this.documents = builder.documents;
        this.marker = builder.marker;
    }

    public final boolean hasFolders() {
        return this.folders != null && !(this.folders instanceof SdkAutoConstructList);
    }

    public final List<FolderMetadata> folders() {
        return this.folders;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<DocumentMetadata> documents() {
        return this.documents;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolders() ? this.folders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesResponse)) {
            return false;
        }
        GetResourcesResponse other = (GetResourcesResponse)((Object)obj);
        return this.hasFolders() == other.hasFolders() && Objects.equals(this.folders(), other.folders()) && this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesResponse").add("Folders", this.hasFolders() ? this.folders() : null).add("Documents", this.hasDocuments() ? this.documents() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Folders": {
                return Optional.ofNullable(clazz.cast(this.folders()));
            }
            case "Documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesResponse, T> g) {
        return obj -> g.apply((GetResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<FolderMetadata> folders = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentMetadata> documents = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesResponse model) {
            super(model);
            this.folders(model.folders);
            this.documents(model.documents);
            this.marker(model.marker);
        }

        public final List<FolderMetadata.Builder> getFolders() {
            List<FolderMetadata.Builder> result = FolderMetadataListCopier.copyToBuilder(this.folders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder folders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(FolderMetadata ... folders) {
            this.folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(Consumer<FolderMetadata.Builder> ... folders) {
            this.folders(Stream.of(folders).map(c -> (FolderMetadata)((FolderMetadata.Builder)FolderMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFolders(Collection<FolderMetadata.BuilderImpl> folders) {
            this.folders = FolderMetadataListCopier.copyFromBuilder(folders);
        }

        public final List<DocumentMetadata.Builder> getDocuments() {
            List<DocumentMetadata.Builder> result = DocumentMetadataListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder documents(Collection<DocumentMetadata> documents) {
            this.documents = DocumentMetadataListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DocumentMetadata ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<DocumentMetadata.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocuments(Collection<DocumentMetadata.BuilderImpl> documents) {
            this.documents = DocumentMetadataListCopier.copyFromBuilder(documents);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public GetResourcesResponse build() {
            return new GetResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesResponse> {
        public Builder folders(Collection<FolderMetadata> var1);

        public Builder folders(FolderMetadata ... var1);

        public Builder folders(Consumer<FolderMetadata.Builder> ... var1);

        public Builder documents(Collection<DocumentMetadata> var1);

        public Builder documents(DocumentMetadata ... var1);

        public Builder documents(Consumer<DocumentMetadata.Builder> ... var1);

        public Builder marker(String var1);
    }
}

