/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadataListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRootFoldersResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeRootFoldersResponse> {
    private static final SdkField<List<FolderMetadata>> FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Folders").getter(DescribeRootFoldersResponse.getter(DescribeRootFoldersResponse::folders)).setter(DescribeRootFoldersResponse.setter(Builder::folders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FolderMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeRootFoldersResponse.getter(DescribeRootFoldersResponse::marker)).setter(DescribeRootFoldersResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDERS_FIELD, MARKER_FIELD));
    private final List<FolderMetadata> folders;
    private final String marker;

    private DescribeRootFoldersResponse(BuilderImpl builder) {
        super(builder);
        this.folders = builder.folders;
        this.marker = builder.marker;
    }

    public final boolean hasFolders() {
        return this.folders != null && !(this.folders instanceof SdkAutoConstructList);
    }

    public final List<FolderMetadata> folders() {
        return this.folders;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolders() ? this.folders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRootFoldersResponse)) {
            return false;
        }
        DescribeRootFoldersResponse other = (DescribeRootFoldersResponse)((Object)obj);
        return this.hasFolders() == other.hasFolders() && Objects.equals(this.folders(), other.folders()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRootFoldersResponse").add("Folders", this.hasFolders() ? this.folders() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Folders": {
                return Optional.ofNullable(clazz.cast(this.folders()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRootFoldersResponse, T> g) {
        return obj -> g.apply((DescribeRootFoldersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<FolderMetadata> folders = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRootFoldersResponse model) {
            super(model);
            this.folders(model.folders);
            this.marker(model.marker);
        }

        public final List<FolderMetadata.Builder> getFolders() {
            List<FolderMetadata.Builder> result = FolderMetadataListCopier.copyToBuilder(this.folders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder folders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(FolderMetadata ... folders) {
            this.folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(Consumer<FolderMetadata.Builder> ... folders) {
            this.folders(Stream.of(folders).map(c -> (FolderMetadata)((FolderMetadata.Builder)FolderMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFolders(Collection<FolderMetadata.BuilderImpl> folders) {
            this.folders = FolderMetadataListCopier.copyFromBuilder(folders);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeRootFoldersResponse build() {
            return new DescribeRootFoldersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRootFoldersResponse> {
        public Builder folders(Collection<FolderMetadata> var1);

        public Builder folders(FolderMetadata ... var1);

        public Builder folders(Consumer<FolderMetadata.Builder> ... var1);

        public Builder marker(String var1);
    }
}

