/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceSortType {
    DATE("DATE"),
    NAME("NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceSortType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSortType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceSortType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSortType> knownValues() {
        return Stream.of(ResourceSortType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

