/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.PrincipalType;
import software.amazon.awssdk.services.workdocs.model.RoleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharePrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharePrincipal> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SharePrincipal.getter(SharePrincipal::id)).setter(SharePrincipal.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SharePrincipal.getter(SharePrincipal::typeAsString)).setter(SharePrincipal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(SharePrincipal.getter(SharePrincipal::roleAsString)).setter(SharePrincipal.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String role;

    private SharePrincipal(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.role = builder.role;
    }

    public String id() {
        return this.id;
    }

    public PrincipalType type() {
        return PrincipalType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public RoleType role() {
        return RoleType.fromValue(this.role);
    }

    public String roleAsString() {
        return this.role;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePrincipal)) {
            return false;
        }
        SharePrincipal other = (SharePrincipal)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.roleAsString(), other.roleAsString());
    }

    public String toString() {
        return ToString.builder((String)"SharePrincipal").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Role", (Object)this.roleAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SharePrincipal, T> g) {
        return obj -> g.apply((SharePrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePrincipal model) {
            this.id(model.id);
            this.type(model.type);
            this.role(model.role);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrincipalType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public SharePrincipal build() {
            return new SharePrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharePrincipal> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(PrincipalType var1);

        public Builder role(String var1);

        public Builder role(RoleType var1);
    }
}

