/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.Principal;
import software.amazon.awssdk.services.workdocs.model.PrincipalListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourcePermissionsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(DescribeResourcePermissionsResponse.getter(DescribeResourcePermissionsResponse::principals)).setter(DescribeResourcePermissionsResponse.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeResourcePermissionsResponse.getter(DescribeResourcePermissionsResponse::marker)).setter(DescribeResourcePermissionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD, MARKER_FIELD));
    private final List<Principal> principals;
    private final String marker;

    private DescribeResourcePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.marker = builder.marker;
    }

    public boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public List<Principal> principals() {
        return this.principals;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePermissionsResponse)) {
            return false;
        }
        DescribeResourcePermissionsResponse other = (DescribeResourcePermissionsResponse)((Object)obj);
        return this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeResourcePermissionsResponse").add("Principals", this.hasPrincipals() ? this.principals() : null).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeResourcePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePermissionsResponse model) {
            super(model);
            this.principals(model.principals);
            this.marker(model.marker);
        }

        public final Collection<Principal.Builder> getPrincipals() {
            if (this.principals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principals != null ? (Collection)this.principals.stream().map(Principal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalListCopier.copyFromBuilder(principals);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeResourcePermissionsResponse build() {
            return new DescribeResourcePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder principals(Consumer<Principal.Builder> ... var1);

        public Builder marker(String var1);
    }
}

