/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.StorageType;
import software.amazon.awssdk.services.workdocs.transform.StorageRuleTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageRuleType
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageRuleType> {
    private final Long storageAllocatedInBytes;
    private final String storageType;

    private StorageRuleType(BuilderImpl builder) {
        this.storageAllocatedInBytes = builder.storageAllocatedInBytes;
        this.storageType = builder.storageType;
    }

    public Long storageAllocatedInBytes() {
        return this.storageAllocatedInBytes;
    }

    public StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public String storageTypeString() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageAllocatedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageRuleType)) {
            return false;
        }
        StorageRuleType other = (StorageRuleType)obj;
        return Objects.equals(this.storageAllocatedInBytes(), other.storageAllocatedInBytes()) && Objects.equals(this.storageTypeString(), other.storageTypeString());
    }

    public String toString() {
        return ToString.builder((String)"StorageRuleType").add("StorageAllocatedInBytes", (Object)this.storageAllocatedInBytes()).add("StorageType", (Object)this.storageTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageAllocatedInBytes": {
                return Optional.of(clazz.cast(this.storageAllocatedInBytes()));
            }
            case "StorageType": {
                return Optional.of(clazz.cast(this.storageTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageRuleTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long storageAllocatedInBytes;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageRuleType model) {
            this.storageAllocatedInBytes(model.storageAllocatedInBytes);
            this.storageType(model.storageType);
        }

        public final Long getStorageAllocatedInBytes() {
            return this.storageAllocatedInBytes;
        }

        @Override
        public final Builder storageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
            return this;
        }

        public final void setStorageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType.toString());
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public StorageRuleType build() {
            return new StorageRuleType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageRuleType> {
        public Builder storageAllocatedInBytes(Long var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);
    }
}

