/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponent;
import software.amazon.awssdk.services.workdocs.model.ResourcePathComponentListCopier;
import software.amazon.awssdk.services.workdocs.transform.ResourcePathMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourcePath
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourcePath> {
    private final List<ResourcePathComponent> components;

    private ResourcePath(BuilderImpl builder) {
        this.components = builder.components;
    }

    public List<ResourcePathComponent> components() {
        return this.components;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.components());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return Objects.equals(this.components(), other.components());
    }

    public String toString() {
        return ToString.builder((String)"ResourcePath").add("Components", this.components()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Components": {
                return Optional.of(clazz.cast(this.components()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourcePathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourcePathComponent> components;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePath model) {
            this.components(model.components);
        }

        public final Collection<ResourcePathComponent.Builder> getComponents() {
            return this.components != null ? (Collection)this.components.stream().map(ResourcePathComponent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder components(Collection<ResourcePathComponent> components) {
            this.components = ResourcePathComponentListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ResourcePathComponent ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        public final void setComponents(Collection<ResourcePathComponent.BuilderImpl> components) {
            this.components = ResourcePathComponentListCopier.copyFromBuilder(components);
        }

        public ResourcePath build() {
            return new ResourcePath(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourcePath> {
        public Builder components(Collection<ResourcePathComponent> var1);

        public Builder components(ResourcePathComponent ... var1);
    }
}

