/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.FolderContentType;
import software.amazon.awssdk.services.workdocs.model.OrderType;
import software.amazon.awssdk.services.workdocs.model.ResourceSortType;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFolderContentsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeFolderContentsRequest> {
    private final String authenticationToken;
    private final String folderId;
    private final String sort;
    private final String order;
    private final Integer limit;
    private final String marker;
    private final String type;
    private final String include;

    private DescribeFolderContentsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.sort = builder.sort;
        this.order = builder.order;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.type = builder.type;
        this.include = builder.include;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String folderId() {
        return this.folderId;
    }

    public ResourceSortType sort() {
        return ResourceSortType.fromValue(this.sort);
    }

    public String sortString() {
        return this.sort;
    }

    public OrderType order() {
        return OrderType.fromValue(this.order);
    }

    public String orderString() {
        return this.order;
    }

    public Integer limit() {
        return this.limit;
    }

    public String marker() {
        return this.marker;
    }

    public FolderContentType type() {
        return FolderContentType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String include() {
        return this.include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.include());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsRequest)) {
            return false;
        }
        DescribeFolderContentsRequest other = (DescribeFolderContentsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.folderId(), other.folderId()) && Objects.equals(this.sortString(), other.sortString()) && Objects.equals(this.orderString(), other.orderString()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.include(), other.include());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFolderContentsRequest").add("AuthenticationToken", (Object)this.authenticationToken()).add("FolderId", (Object)this.folderId()).add("Sort", (Object)this.sortString()).add("Order", (Object)this.orderString()).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).add("Type", (Object)this.typeString()).add("Include", (Object)this.include()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.of(clazz.cast(this.folderId()));
            }
            case "Sort": {
                return Optional.of(clazz.cast(this.sortString()));
            }
            case "Order": {
                return Optional.of(clazz.cast(this.orderString()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Include": {
                return Optional.of(clazz.cast(this.include()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private String sort;
        private String order;
        private Integer limit;
        private String marker;
        private String type;
        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.sort(model.sort);
            this.order(model.order);
            this.limit(model.limit);
            this.marker(model.marker);
            this.type(model.type);
            this.include(model.include);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final String getSort() {
            return this.sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(ResourceSortType sort) {
            this.sort(sort.toString());
            return this;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        public final String getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderType order) {
            this.order(order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FolderContentType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getInclude() {
            return this.include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeFolderContentsRequest build() {
            return new DescribeFolderContentsRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, DescribeFolderContentsRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder sort(String var1);

        public Builder sort(ResourceSortType var1);

        public Builder order(String var1);

        public Builder order(OrderType var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);

        public Builder type(String var1);

        public Builder type(FolderContentType var1);

        public Builder include(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

