/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.workdocs.model.OrganizationUserListCopier;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUsersResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeUsersResponse> {
    private final List<User> users;
    private final Long totalNumberOfUsers;
    private final String marker;

    private DescribeUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.totalNumberOfUsers = builder.totalNumberOfUsers;
        this.marker = builder.marker;
    }

    public List<User> users() {
        return this.users;
    }

    public Long totalNumberOfUsers() {
        return this.totalNumberOfUsers;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsersResponse)) {
            return false;
        }
        DescribeUsersResponse other = (DescribeUsersResponse)((Object)obj);
        return Objects.equals(this.users(), other.users()) && Objects.equals(this.totalNumberOfUsers(), other.totalNumberOfUsers()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUsersResponse").add("Users", this.users()).add("TotalNumberOfUsers", (Object)this.totalNumberOfUsers()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Users": {
                return Optional.of(clazz.cast(this.users()));
            }
            case "TotalNumberOfUsers": {
                return Optional.of(clazz.cast(this.totalNumberOfUsers()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<User> users;
        private Long totalNumberOfUsers;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsersResponse model) {
            this.users(model.users);
            this.totalNumberOfUsers(model.totalNumberOfUsers);
            this.marker(model.marker);
        }

        public final Collection<User.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(User::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = OrganizationUserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = OrganizationUserListCopier.copyFromBuilder(users);
        }

        public final Long getTotalNumberOfUsers() {
            return this.totalNumberOfUsers;
        }

        @Override
        public final Builder totalNumberOfUsers(Long totalNumberOfUsers) {
            this.totalNumberOfUsers = totalNumberOfUsers;
            return this;
        }

        public final void setTotalNumberOfUsers(Long totalNumberOfUsers) {
            this.totalNumberOfUsers = totalNumberOfUsers;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeUsersResponse build() {
            return new DescribeUsersResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeUsersResponse> {
        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder totalNumberOfUsers(Long var1);

        public Builder marker(String var1);
    }
}

