/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.workdocs.model.Principal;
import software.amazon.awssdk.services.workdocs.model.PrincipalListCopier;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeResourcePermissionsResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
    private final List<Principal> principals;
    private final String marker;

    private DescribeResourcePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.marker = builder.marker;
    }

    public List<Principal> principals() {
        return this.principals;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePermissionsResponse)) {
            return false;
        }
        DescribeResourcePermissionsResponse other = (DescribeResourcePermissionsResponse)((Object)obj);
        return Objects.equals(this.principals(), other.principals()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeResourcePermissionsResponse").add("Principals", this.principals()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principals": {
                return Optional.of(clazz.cast(this.principals()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private List<Principal> principals;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePermissionsResponse model) {
            this.principals(model.principals);
            this.marker(model.marker);
        }

        public final Collection<Principal.Builder> getPrincipals() {
            return this.principals != null ? (Collection)this.principals.stream().map(Principal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalListCopier.copyFromBuilder(principals);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeResourcePermissionsResponse build() {
            return new DescribeResourcePermissionsResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder marker(String var1);
    }
}

