/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.CommentStatusType;
import software.amazon.awssdk.services.workdocs.model.User;
import software.amazon.awssdk.services.workdocs.transform.CommentMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CommentMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, CommentMetadata> {
    private final String commentId;
    private final User contributor;
    private final Instant createdTimestamp;
    private final String commentStatus;
    private final String recipientId;

    private CommentMetadata(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.commentStatus = builder.commentStatus;
        this.recipientId = builder.recipientId;
    }

    public String commentId() {
        return this.commentId;
    }

    public User contributor() {
        return this.contributor;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public CommentStatusType commentStatus() {
        return CommentStatusType.fromValue(this.commentStatus);
    }

    public String commentStatusString() {
        return this.commentStatus;
    }

    public String recipientId() {
        return this.recipientId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.commentStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentMetadata)) {
            return false;
        }
        CommentMetadata other = (CommentMetadata)obj;
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.contributor(), other.contributor()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.commentStatusString(), other.commentStatusString()) && Objects.equals(this.recipientId(), other.recipientId());
    }

    public String toString() {
        return ToString.builder((String)"CommentMetadata").add("CommentId", (Object)this.commentId()).add("Contributor", (Object)this.contributor()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("CommentStatus", (Object)this.commentStatusString()).add("RecipientId", (Object)this.recipientId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommentId": {
                return Optional.of(clazz.cast(this.commentId()));
            }
            case "Contributor": {
                return Optional.of(clazz.cast(this.contributor()));
            }
            case "CreatedTimestamp": {
                return Optional.of(clazz.cast(this.createdTimestamp()));
            }
            case "CommentStatus": {
                return Optional.of(clazz.cast(this.commentStatusString()));
            }
            case "RecipientId": {
                return Optional.of(clazz.cast(this.recipientId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommentMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String commentId;
        private User contributor;
        private Instant createdTimestamp;
        private String commentStatus;
        private String recipientId;

        private BuilderImpl() {
        }

        private BuilderImpl(CommentMetadata model) {
            this.commentId(model.commentId);
            this.contributor(model.contributor);
            this.createdTimestamp(model.createdTimestamp);
            this.commentStatus(model.commentStatus);
            this.recipientId(model.recipientId);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final User.Builder getContributor() {
            return this.contributor != null ? this.contributor.toBuilder() : null;
        }

        @Override
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final void setContributor(User.BuilderImpl contributor) {
            this.contributor = contributor != null ? contributor.build() : null;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final String getCommentStatus() {
            return this.commentStatus;
        }

        @Override
        public final Builder commentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
            return this;
        }

        @Override
        public final Builder commentStatus(CommentStatusType commentStatus) {
            this.commentStatus(commentStatus.toString());
            return this;
        }

        public final void setCommentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
        }

        public final String getRecipientId() {
            return this.recipientId;
        }

        @Override
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        public CommentMetadata build() {
            return new CommentMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CommentMetadata> {
        public Builder commentId(String var1);

        public Builder contributor(User var1);

        default public Builder contributor(Consumer<User.Builder> contributor) {
            return this.contributor((User)((User.Builder)User.builder().apply(contributor)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder commentStatus(String var1);

        public Builder commentStatus(CommentStatusType var1);

        public Builder recipientId(String var1);
    }
}

