/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.workdocs.model.ResourceType;
import software.amazon.awssdk.services.workdocs.model.UserMetadata;
import software.amazon.awssdk.services.workdocs.transform.ResourceMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceMetadata> {
    private final String type;
    private final String name;
    private final String originalName;
    private final String id;
    private final String versionId;
    private final UserMetadata owner;
    private final String parentId;

    private ResourceMetadata(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.originalName = builder.originalName;
        this.id = builder.id;
        this.versionId = builder.versionId;
        this.owner = builder.owner;
        this.parentId = builder.parentId;
    }

    public ResourceType type() {
        return ResourceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String originalName() {
        return this.originalName;
    }

    public String id() {
        return this.id;
    }

    public String versionId() {
        return this.versionId;
    }

    public UserMetadata owner() {
        return this.owner;
    }

    public String parentId() {
        return this.parentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMetadata)) {
            return false;
        }
        ResourceMetadata other = (ResourceMetadata)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originalName(), other.originalName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.parentId(), other.parentId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.originalName() != null) {
            sb.append("OriginalName: ").append(this.originalName()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.parentId() != null) {
            sb.append("ParentId: ").append(this.parentId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "OriginalName": {
                return Optional.of(clazz.cast(this.originalName()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "ParentId": {
                return Optional.of(clazz.cast(this.parentId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String originalName;
        private String id;
        private String versionId;
        private UserMetadata owner;
        private String parentId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMetadata model) {
            this.type(model.type);
            this.name(model.name);
            this.originalName(model.originalName);
            this.id(model.id);
            this.versionId(model.versionId);
            this.owner(model.owner);
            this.parentId(model.parentId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOriginalName() {
            return this.originalName;
        }

        @Override
        public final Builder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public final void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final UserMetadata.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(UserMetadata owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(UserMetadata.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public ResourceMetadata build() {
            return new ResourceMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceMetadata> {
        public Builder type(String var1);

        public Builder type(ResourceType var1);

        public Builder name(String var1);

        public Builder originalName(String var1);

        public Builder id(String var1);

        public Builder versionId(String var1);

        public Builder owner(UserMetadata var1);

        default public Builder owner(Consumer<UserMetadata.Builder> owner) {
            return this.owner((UserMetadata)((UserMetadata.Builder)UserMetadata.builder().apply(owner)).build());
        }

        public Builder parentId(String var1);
    }
}

