/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataMapCopier;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.WorkDocsResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDocumentVersionResponse
extends WorkDocsResponse
implements ToCopyableBuilder<Builder, GetDocumentVersionResponse> {
    private final DocumentVersionMetadata metadata;
    private final Map<String, String> customMetadata;

    private GetDocumentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    public DocumentVersionMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> customMetadata() {
        return this.customMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.customMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentVersionResponse)) {
            return false;
        }
        GetDocumentVersionResponse other = (GetDocumentVersionResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.customMetadata(), other.customMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.customMetadata() != null) {
            sb.append("CustomMetadata: ").append(this.customMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "CustomMetadata": {
                return Optional.of(clazz.cast(this.customMetadata()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsResponse.BuilderImpl
    implements Builder {
        private DocumentVersionMetadata metadata;
        private Map<String, String> customMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentVersionResponse model) {
            this.metadata(model.metadata);
            this.customMetadata(model.customMetadata);
        }

        public final DocumentVersionMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(DocumentVersionMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(DocumentVersionMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        @Override
        public GetDocumentVersionResponse build() {
            return new GetDocumentVersionResponse(this);
        }
    }

    public static interface Builder
    extends WorkDocsResponse.Builder,
    CopyableBuilder<Builder, GetDocumentVersionResponse> {
        public Builder metadata(DocumentVersionMetadata var1);

        default public Builder metadata(Consumer<DocumentVersionMetadata.Builder> metadata) {
            return this.metadata((DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().apply(metadata)).build());
        }

        public Builder customMetadata(Map<String, String> var1);
    }
}

