/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDocumentVersionsRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, DescribeDocumentVersionsRequest> {
    private final String authenticationToken;
    private final String documentId;
    private final String marker;
    private final Integer limit;
    private final String include;
    private final String fields;

    private DescribeDocumentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.marker = builder.marker;
        this.limit = builder.limit;
        this.include = builder.include;
        this.fields = builder.fields;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String documentId() {
        return this.documentId;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    public String include() {
        return this.include;
    }

    public String fields() {
        return this.fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.include());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentVersionsRequest)) {
            return false;
        }
        DescribeDocumentVersionsRequest other = (DescribeDocumentVersionsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.include(), other.include()) && Objects.equals(this.fields(), other.fields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.documentId() != null) {
            sb.append("DocumentId: ").append(this.documentId()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.include() != null) {
            sb.append("Include: ").append(this.include()).append(",");
        }
        if (this.fields() != null) {
            sb.append("Fields: ").append(this.fields()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "DocumentId": {
                return Optional.of(clazz.cast(this.documentId()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Include": {
                return Optional.of(clazz.cast(this.include()));
            }
            case "Fields": {
                return Optional.of(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String documentId;
        private String marker;
        private Integer limit;
        private String include;
        private String fields;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentVersionsRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.documentId(model.documentId);
            this.marker(model.marker);
            this.limit(model.limit);
            this.include(model.include);
            this.fields(model.fields);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getInclude() {
            return this.include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        public final String getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDocumentVersionsRequest build() {
            return new DescribeDocumentVersionsRequest(this);
        }
    }

    public static interface Builder
    extends WorkDocsRequest.Builder,
    CopyableBuilder<Builder, DescribeDocumentVersionsRequest> {
        public Builder authenticationToken(String var1);

        public Builder documentId(String var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder include(String var1);

        public Builder fields(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

