/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

@SdkInternalApi
public class DocumentVersionMetadataMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").build();
    private static final MarshallingInfo<Long> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final MarshallingInfo<String> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Signature").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").build();
    private static final MarshallingInfo<Instant> MODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModifiedTimestamp").build();
    private static final MarshallingInfo<Instant> CONTENTCREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentCreatedTimestamp").build();
    private static final MarshallingInfo<Instant> CONTENTMODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentModifiedTimestamp").build();
    private static final MarshallingInfo<String> CREATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorId").build();
    private static final MarshallingInfo<Map> THUMBNAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Thumbnail").build();
    private static final MarshallingInfo<Map> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final DocumentVersionMetadataMarshaller INSTANCE = new DocumentVersionMetadataMarshaller();

    public static DocumentVersionMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentVersionMetadata documentVersionMetadata, ProtocolMarshaller protocolMarshaller) {
        if (documentVersionMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentVersionMetadata.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.contentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.size(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.signature(), SIGNATURE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.createdTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.modifiedTimestamp(), MODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.contentCreatedTimestamp(), CONTENTCREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.contentModifiedTimestamp(), CONTENTMODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)documentVersionMetadata.creatorId(), CREATORID_BINDING);
            protocolMarshaller.marshall(documentVersionMetadata.thumbnailStrings(), THUMBNAIL_BINDING);
            protocolMarshaller.marshall(documentVersionMetadata.sourceStrings(), SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

