/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.OrderType;
import software.amazon.awssdk.services.workdocs.model.UserFilterType;
import software.amazon.awssdk.services.workdocs.model.UserSortType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUsersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeUsersRequest> {
    private final String authenticationToken;
    private final String organizationId;
    private final String userIds;
    private final String query;
    private final String include;
    private final String order;
    private final String sort;
    private final String marker;
    private final Integer limit;
    private final String fields;

    private DescribeUsersRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.organizationId = builder.organizationId;
        this.userIds = builder.userIds;
        this.query = builder.query;
        this.include = builder.include;
        this.order = builder.order;
        this.sort = builder.sort;
        this.marker = builder.marker;
        this.limit = builder.limit;
        this.fields = builder.fields;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String userIds() {
        return this.userIds;
    }

    public String query() {
        return this.query;
    }

    public UserFilterType include() {
        return UserFilterType.fromValue(this.include);
    }

    public String includeString() {
        return this.include;
    }

    public OrderType order() {
        return OrderType.fromValue(this.order);
    }

    public String orderString() {
        return this.order;
    }

    public UserSortType sort() {
        return UserSortType.fromValue(this.sort);
    }

    public String sortString() {
        return this.sort;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    public String fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsersRequest)) {
            return false;
        }
        DescribeUsersRequest other = (DescribeUsersRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.userIds(), other.userIds()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.includeString(), other.includeString()) && Objects.equals(this.orderString(), other.orderString()) && Objects.equals(this.sortString(), other.sortString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.fields(), other.fields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.organizationId() != null) {
            sb.append("OrganizationId: ").append(this.organizationId()).append(",");
        }
        if (this.userIds() != null) {
            sb.append("UserIds: ").append(this.userIds()).append(",");
        }
        if (this.query() != null) {
            sb.append("Query: ").append(this.query()).append(",");
        }
        if (this.includeString() != null) {
            sb.append("Include: ").append(this.includeString()).append(",");
        }
        if (this.orderString() != null) {
            sb.append("Order: ").append(this.orderString()).append(",");
        }
        if (this.sortString() != null) {
            sb.append("Sort: ").append(this.sortString()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.fields() != null) {
            sb.append("Fields: ").append(this.fields()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "OrganizationId": {
                return Optional.of(clazz.cast(this.organizationId()));
            }
            case "UserIds": {
                return Optional.of(clazz.cast(this.userIds()));
            }
            case "Query": {
                return Optional.of(clazz.cast(this.query()));
            }
            case "Include": {
                return Optional.of(clazz.cast(this.includeString()));
            }
            case "Order": {
                return Optional.of(clazz.cast(this.orderString()));
            }
            case "Sort": {
                return Optional.of(clazz.cast(this.sortString()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Fields": {
                return Optional.of(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String organizationId;
        private String userIds;
        private String query;
        private String include;
        private String order;
        private String sort;
        private String marker;
        private Integer limit;
        private String fields;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsersRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.organizationId(model.organizationId);
            this.userIds(model.userIds);
            this.query(model.query);
            this.include(model.include);
            this.order(model.order);
            this.sort(model.sort);
            this.marker(model.marker);
            this.limit(model.limit);
            this.fields(model.fields);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getUserIds() {
            return this.userIds;
        }

        @Override
        public final Builder userIds(String userIds) {
            this.userIds = userIds;
            return this;
        }

        public final void setUserIds(String userIds) {
            this.userIds = userIds;
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final String getInclude() {
            return this.include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public final Builder include(UserFilterType include) {
            this.include(include.toString());
            return this;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        public final String getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderType order) {
            this.order(order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        public final String getSort() {
            return this.sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(UserSortType sort) {
            this.sort(sort.toString());
            return this;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        public DescribeUsersRequest build() {
            return new DescribeUsersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeUsersRequest> {
        public Builder authenticationToken(String var1);

        public Builder organizationId(String var1);

        public Builder userIds(String var1);

        public Builder query(String var1);

        public Builder include(String var1);

        public Builder include(UserFilterType var1);

        public Builder order(String var1);

        public Builder order(OrderType var1);

        public Builder sort(String var1);

        public Builder sort(UserSortType var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder fields(String var1);
    }
}

