/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeResourcePermissionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeResourcePermissionsRequest> {
    private final String authenticationToken;
    private final String resourceId;
    private final String principalId;
    private final Integer limit;
    private final String marker;

    private DescribeResourcePermissionsRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.principalId = builder.principalId;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String principalId() {
        return this.principalId;
    }

    public Integer limit() {
        return this.limit;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePermissionsRequest)) {
            return false;
        }
        DescribeResourcePermissionsRequest other = (DescribeResourcePermissionsRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.principalId() != null) {
            sb.append("PrincipalId: ").append(this.principalId()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "PrincipalId": {
                return Optional.of(clazz.cast(this.principalId()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String resourceId;
        private String principalId;
        private Integer limit;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePermissionsRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.resourceId(model.resourceId);
            this.principalId(model.principalId);
            this.limit(model.limit);
            this.marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeResourcePermissionsRequest build() {
            return new DescribeResourcePermissionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeResourcePermissionsRequest> {
        public Builder authenticationToken(String var1);

        public Builder resourceId(String var1);

        public Builder principalId(String var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);
    }
}

