/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.Comment;
import software.amazon.awssdk.services.workdocs.model.CommentListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCommentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCommentsResponse> {
    private final List<Comment> comments;
    private final String marker;

    private DescribeCommentsResponse(BuilderImpl builder) {
        this.comments = builder.comments;
        this.marker = builder.marker;
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comments());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommentsResponse)) {
            return false;
        }
        DescribeCommentsResponse other = (DescribeCommentsResponse)((Object)obj);
        return Objects.equals(this.comments(), other.comments()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.comments() != null) {
            sb.append("Comments: ").append(this.comments()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comments": {
                return Optional.of(clazz.cast(this.comments()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Comment> comments;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommentsResponse model) {
            this.comments(model.comments);
            this.marker(model.marker);
        }

        public final Collection<Comment.Builder> getComments() {
            return this.comments != null ? (Collection)this.comments.stream().map(Comment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder comments(Collection<Comment> comments) {
            this.comments = CommentListCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Comment ... comments) {
            this.comments(Arrays.asList(comments));
            return this;
        }

        public final void setComments(Collection<Comment.BuilderImpl> comments) {
            this.comments = CommentListCopier.copyFromBuilder(comments);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeCommentsResponse build() {
            return new DescribeCommentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCommentsResponse> {
        public Builder comments(Collection<Comment> var1);

        public Builder comments(Comment ... var1);

        public Builder marker(String var1);
    }
}

