/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.SharedLabelsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteLabelsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteLabelsRequest> {
    private final String resourceId;
    private final String authenticationToken;
    private final List<String> labels;
    private final Boolean deleteAll;

    private DeleteLabelsRequest(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.authenticationToken = builder.authenticationToken;
        this.labels = builder.labels;
        this.deleteAll = builder.deleteAll;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public List<String> labels() {
        return this.labels;
    }

    public Boolean deleteAll() {
        return this.deleteAll;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAll());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLabelsRequest)) {
            return false;
        }
        DeleteLabelsRequest other = (DeleteLabelsRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.deleteAll(), other.deleteAll());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        if (this.deleteAll() != null) {
            sb.append("DeleteAll: ").append(this.deleteAll()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
            case "DeleteAll": {
                return Optional.of(clazz.cast(this.deleteAll()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String authenticationToken;
        private List<String> labels;
        private Boolean deleteAll;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLabelsRequest model) {
            this.resourceId(model.resourceId);
            this.authenticationToken(model.authenticationToken);
            this.labels(model.labels);
            this.deleteAll(model.deleteAll);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        public final Boolean getDeleteAll() {
            return this.deleteAll;
        }

        @Override
        public final Builder deleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
            return this;
        }

        public final void setDeleteAll(Boolean deleteAll) {
            this.deleteAll = deleteAll;
        }

        public DeleteLabelsRequest build() {
            return new DeleteLabelsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteLabelsRequest> {
        public Builder resourceId(String var1);

        public Builder authenticationToken(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder deleteAll(Boolean var1);
    }
}

