/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.FolderContentType;
import software.amazon.awssdk.services.workdocs.model.OrderType;
import software.amazon.awssdk.services.workdocs.model.ResourceSortType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFolderContentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeFolderContentsRequest> {
    private final String authenticationToken;
    private final String folderId;
    private final String sort;
    private final String order;
    private final Integer limit;
    private final String marker;
    private final String type;
    private final String include;

    private DescribeFolderContentsRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.sort = builder.sort;
        this.order = builder.order;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.type = builder.type;
        this.include = builder.include;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String folderId() {
        return this.folderId;
    }

    public ResourceSortType sort() {
        return ResourceSortType.fromValue(this.sort);
    }

    public String sortString() {
        return this.sort;
    }

    public OrderType order() {
        return OrderType.fromValue(this.order);
    }

    public String orderString() {
        return this.order;
    }

    public Integer limit() {
        return this.limit;
    }

    public String marker() {
        return this.marker;
    }

    public FolderContentType type() {
        return FolderContentType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String include() {
        return this.include;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.folderId() == null ? 0 : this.folderId().hashCode());
        hashCode = 31 * hashCode + (this.sortString() == null ? 0 : this.sortString().hashCode());
        hashCode = 31 * hashCode + (this.orderString() == null ? 0 : this.orderString().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.include() == null ? 0 : this.include().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsRequest)) {
            return false;
        }
        DescribeFolderContentsRequest other = (DescribeFolderContentsRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.folderId() == null ^ this.folderId() == null) {
            return false;
        }
        if (other.folderId() != null && !other.folderId().equals(this.folderId())) {
            return false;
        }
        if (other.sortString() == null ^ this.sortString() == null) {
            return false;
        }
        if (other.sortString() != null && !other.sortString().equals(this.sortString())) {
            return false;
        }
        if (other.orderString() == null ^ this.orderString() == null) {
            return false;
        }
        if (other.orderString() != null && !other.orderString().equals(this.orderString())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.include() == null ^ this.include() == null) {
            return false;
        }
        return other.include() == null || other.include().equals(this.include());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.folderId() != null) {
            sb.append("FolderId: ").append(this.folderId()).append(",");
        }
        if (this.sortString() != null) {
            sb.append("Sort: ").append(this.sortString()).append(",");
        }
        if (this.orderString() != null) {
            sb.append("Order: ").append(this.orderString()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.include() != null) {
            sb.append("Include: ").append(this.include()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "FolderId": {
                return Optional.of(clazz.cast(this.folderId()));
            }
            case "Sort": {
                return Optional.of(clazz.cast(this.sortString()));
            }
            case "Order": {
                return Optional.of(clazz.cast(this.orderString()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Include": {
                return Optional.of(clazz.cast(this.include()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String folderId;
        private String sort;
        private String order;
        private Integer limit;
        private String marker;
        private String type;
        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.folderId(model.folderId);
            this.sort(model.sort);
            this.order(model.order);
            this.limit(model.limit);
            this.marker(model.marker);
            this.type(model.type);
            this.include(model.include);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getFolderId() {
            return this.folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public final String getSort() {
            return this.sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(ResourceSortType sort) {
            this.sort(sort.toString());
            return this;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        public final String getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderType order) {
            this.order(order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FolderContentType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getInclude() {
            return this.include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        public DescribeFolderContentsRequest build() {
            return new DescribeFolderContentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFolderContentsRequest> {
        public Builder authenticationToken(String var1);

        public Builder folderId(String var1);

        public Builder sort(String var1);

        public Builder sort(ResourceSortType var1);

        public Builder order(String var1);

        public Builder order(OrderType var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);

        public Builder type(String var1);

        public Builder type(FolderContentType var1);

        public Builder include(String var1);
    }
}

