/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteUserRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteUserRequest> {
    private final String authenticationToken;
    private final String userId;

    private DeleteUserRequest(BuilderImpl builder) {
        this.authenticationToken = builder.authenticationToken;
        this.userId = builder.userId;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        hashCode = 31 * hashCode + (this.userId() == null ? 0 : this.userId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserRequest)) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest)((Object)obj);
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        if (other.authenticationToken() != null && !other.authenticationToken().equals(this.authenticationToken())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        return other.userId() == null || other.userId().equals(this.userId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.of(clazz.cast(this.authenticationToken()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserRequest model) {
            this.authenticationToken(model.authenticationToken);
            this.userId(model.userId);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteUserRequest> {
        public Builder authenticationToken(String var1);

        public Builder userId(String var1);
    }
}

