/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.Comment;
import software.amazon.awssdk.services.workdocs.model.CommentListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCommentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCommentsResponse> {
    private final List<Comment> comments;
    private final String marker;

    private DescribeCommentsResponse(BuilderImpl builder) {
        this.comments = builder.comments;
        this.marker = builder.marker;
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.comments() == null ? 0 : this.comments().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommentsResponse)) {
            return false;
        }
        DescribeCommentsResponse other = (DescribeCommentsResponse)((Object)obj);
        if (other.comments() == null ^ this.comments() == null) {
            return false;
        }
        if (other.comments() != null && !other.comments().equals(this.comments())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comments() != null) {
            sb.append("Comments: ").append(this.comments()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Comment> comments;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommentsResponse model) {
            this.setComments(model.comments);
            this.setMarker(model.marker);
        }

        public final Collection<Comment> getComments() {
            return this.comments;
        }

        @Override
        public final Builder comments(Collection<Comment> comments) {
            this.comments = CommentListCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Comment ... comments) {
            this.comments(Arrays.asList(comments));
            return this;
        }

        public final void setComments(Collection<Comment> comments) {
            this.comments = CommentListCopier.copy(comments);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeCommentsResponse build() {
            return new DescribeCommentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCommentsResponse> {
        public Builder comments(Collection<Comment> var1);

        public Builder comments(Comment ... var1);

        public Builder marker(String var1);
    }
}

