/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType;
import software.amazon.awssdk.services.workdocs.model.SubscriptionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateNotificationSubscriptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
    private final String organizationId;
    private final String endpoint;
    private final String protocol;
    private final String subscriptionType;

    private CreateNotificationSubscriptionRequest(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.endpoint = builder.endpoint;
        this.protocol = builder.protocol;
        this.subscriptionType = builder.subscriptionType;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String protocol() {
        return this.protocol;
    }

    public String subscriptionType() {
        return this.subscriptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.organizationId() == null ? 0 : this.organizationId().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.subscriptionType() == null ? 0 : this.subscriptionType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationSubscriptionRequest)) {
            return false;
        }
        CreateNotificationSubscriptionRequest other = (CreateNotificationSubscriptionRequest)((Object)obj);
        if (other.organizationId() == null ^ this.organizationId() == null) {
            return false;
        }
        if (other.organizationId() != null && !other.organizationId().equals(this.organizationId())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.subscriptionType() == null ^ this.subscriptionType() == null) {
            return false;
        }
        return other.subscriptionType() == null || other.subscriptionType().equals(this.subscriptionType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.organizationId() != null) {
            sb.append("OrganizationId: ").append(this.organizationId()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.subscriptionType() != null) {
            sb.append("SubscriptionType: ").append(this.subscriptionType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String organizationId;
        private String endpoint;
        private String protocol;
        private String subscriptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationSubscriptionRequest model) {
            this.setOrganizationId(model.organizationId);
            this.setEndpoint(model.endpoint);
            this.setProtocol(model.protocol);
            this.setSubscriptionType(model.subscriptionType);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public CreateNotificationSubscriptionRequest build() {
            return new CreateNotificationSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
        public Builder organizationId(String var1);

        public Builder endpoint(String var1);

        public Builder protocol(String var1);

        public Builder protocol(SubscriptionProtocolType var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);
    }
}

