/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;

public class DocumentVersionMetadataUnmarshaller
implements Unmarshaller<DocumentVersionMetadata, JsonUnmarshallerContext> {
    private static DocumentVersionMetadataUnmarshaller INSTANCE;

    public DocumentVersionMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentVersionMetadata.Builder documentVersionMetadataBuilder = DocumentVersionMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Size", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.size((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Signature", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.signature((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedTimestamp", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.createdTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ModifiedTimestamp", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.modifiedTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentCreatedTimestamp", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.contentCreatedTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentModifiedTimestamp", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.contentModifiedTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatorId", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.creatorId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Thumbnail", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.thumbnail(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Source", targetDepth)) {
                    context.nextToken();
                    documentVersionMetadataBuilder.source(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DocumentVersionMetadata)documentVersionMetadataBuilder.build();
    }

    public static DocumentVersionMetadataUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DocumentVersionMetadataUnmarshaller();
        }
        return INSTANCE;
    }
}

