/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.workdocs.model.Principal;
import software.amazon.awssdk.services.workdocs.model.PrincipalListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeResourcePermissionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
    private final List<Principal> principals;
    private final String marker;

    private DescribeResourcePermissionsResponse(BuilderImpl builder) {
        this.principals = builder.principals;
        this.marker = builder.marker;
    }

    public List<Principal> principals() {
        return this.principals;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.principals() == null ? 0 : this.principals().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePermissionsResponse)) {
            return false;
        }
        DescribeResourcePermissionsResponse other = (DescribeResourcePermissionsResponse)((Object)obj);
        if (other.principals() == null ^ this.principals() == null) {
            return false;
        }
        if (other.principals() != null && !other.principals().equals(this.principals())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.principals() != null) {
            sb.append("Principals: ").append(this.principals()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Principal> principals;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePermissionsResponse model) {
            this.setPrincipals(model.principals);
            this.setMarker(model.marker);
        }

        public final Collection<Principal> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
        }

        @SafeVarargs
        public final void setPrincipals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeResourcePermissionsResponse build() {
            return new DescribeResourcePermissionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder marker(String var1);
    }
}

