/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.workdocs.model.LabelsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLabelsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLabelsRequest> {
    private final String resourceId;
    private final List<String> labels;
    private final String authenticationToken;

    private CreateLabelsRequest(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.labels = builder.labels;
        this.authenticationToken = builder.authenticationToken;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String authenticationToken() {
        return this.authenticationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.labels() == null ? 0 : this.labels().hashCode());
        hashCode = 31 * hashCode + (this.authenticationToken() == null ? 0 : this.authenticationToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelsRequest)) {
            return false;
        }
        CreateLabelsRequest other = (CreateLabelsRequest)((Object)obj);
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.labels() == null ^ this.labels() == null) {
            return false;
        }
        if (other.labels() != null && !other.labels().equals(this.labels())) {
            return false;
        }
        if (other.authenticationToken() == null ^ this.authenticationToken() == null) {
            return false;
        }
        return other.authenticationToken() == null || other.authenticationToken().equals(this.authenticationToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        if (this.authenticationToken() != null) {
            sb.append("AuthenticationToken: ").append(this.authenticationToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> labels;
        private String authenticationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelsRequest model) {
            this.setResourceId(model.resourceId);
            this.setLabels(model.labels);
            this.setAuthenticationToken(model.authenticationToken);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = LabelsCopier.copy(labels);
        }

        @SafeVarargs
        public final void setLabels(String ... labels) {
            this.labels(Arrays.asList(labels));
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public CreateLabelsRequest build() {
            return new CreateLabelsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLabelsRequest> {
        public Builder resourceId(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder authenticationToken(String var1);
    }
}

